# 自定义请求参数

很多情境下，编辑器与后台通信需要有登录状态，很多时候后台需要额外的参数。
ueditor自1.4.0版本提供设置额外参数的命令**serverparam**命令，可动态设置自定义参数表。
在向后台发出请求时，会把参数表以GET方式加到请求里。

另外，编辑器上传使用webuploader插件，在低版本的ie下，浏览器使用Flash形式的上传。
flash发送的请求不带有cookie，这里也需要额外的参数，让后台判断是否登录。

### 设置自定义参数表
通过serverparam命令设置自定义参数表，**有四种调用方式**，看下面的例子（下文的ue指编辑器实例）：
```javascript
/* 1.传入函数,命令里执行该函数得到参数表,添加到已有参数表里 */
ue.execCommand('serverparam', function(editor){
	return {'key': 'value'};
}};
```
```javascript
/* 2.传入参数表,添加到已有参数表里 */
ue.execCommand('serverparam', {'key': 'value'});
```
```javascript
/* 3.按照键值添加参数 */
ue.execCommand('serverparam', 'key', 'value');
```
```javascript
/* 4.清除参数表 */
ue.execCommand('serverparam'};
```

### 查询自定义参数表
前端发出请求时，会通过queryCommandValue方法，查询当前自定义参数表，把参数表以GET方式加到请求里：
```javascript
ue.queryCommandValue('serverparam'); //返回参数值键值对的对象
```

### 使用例子
```javascript
var ue = UE.getEditor('container');
ue.execCommand('serverparam', {
	'key1': 'value1',
	'key2': 'value2',
});
```
提交请求的时候会把key1和key2一起以GET的方式发送到后台。后台再通过$_GET["key1"]和$_GET["key2"]获取key1和key2的值。
